//=============================================================================
// KNSMZ_SkillToLearn.js
//=============================================================================
/*:
 * @target MZ
 * @plugindesc ver.1.0.1 スキル画面で習得予定のスキルを表示します
 * @author 莞爾の草
 * @url https://kanjinokusargss3.hatenablog.com/
 * 
 * @param displayLearningsInBattle
 * @text 戦闘画面にも予定スキル表示
 * @type boolean
 * @default false
 * 
 * @param TextColorLearning
 * @text 【文字色】予定スキル
 * @desc 数字のみの場合ウィンドウスキンで指定された文字色を指定。#ffffffのように#から始めた場合は直接カラーコードを指定可能。
 * @type text
 * @default 2
 * 
 * @help
 * ■更新履歴
 * ver. 1.0.0(2022-4-30)
 * - デモ版
 * ver. 1.0.1(2022-4-30)
 * - 習得予定スキルの文字色を指定可能に
 */

//========================================================
// new KNSMZ_EquipJob
//========================================================
const KNSMZ_SkillToLearn = {
	name: 'KNSMZ_SkillToLearn',
	getLearnings: function(actor){
		const level = actor._level;
		const lns = actor.currentClass().learnings;
		return lns.filter(ln => ln && ln.level > level);
	},
	reColor: /^#/,
	getColor: function(name){
		const param = this.param[name] || "0";
		return this.reColor.test(param) ? param : ColorManager.textColor(Math.floor(param));
	}
};

(function(){
	this.param = PluginManager.parameters(this.name);
	const extractBool = function(name){
		this[name] = this.param[name] == 'true';
	}.bind(this);
	extractBool('displayLearningsInBattle');
}).call(KNSMZ_SkillToLearn);

//========================================================
// alias Window_SkillList
//========================================================
(function(){
const _Window_SkillList_makeItemList = Window_SkillList.prototype.makeItemList;
Window_SkillList.prototype.makeItemList = function() {
	_Window_SkillList_makeItemList.apply(this, arguments);
	this.knsAddSkillToLearn();
};

Window_SkillList.prototype.knsAddSkillToLearn = function(){
	if (this._actor){
		const lns = KNSMZ_SkillToLearn.getLearnings(this._actor).map(
			ln => $dataSkills[ln.skillId]);
		this._data = [...new Set(this._data.concat(lns))];
	}
}

Window_SkillList.prototype.knsIsSkillToLearn = function(skill){
	return skill && this._actor && !this._actor.skills().includes(skill);
}

const _Window_SkillList_isEnabled = Window_SkillList.prototype.isEnabled;
Window_SkillList.prototype.isEnabled = function(item) {
	if (_Window_SkillList_isEnabled.apply(this, arguments)){
		return this.knsIsSkillToLearn(item) == false;
	}else{
		return false;
	};
};

const _Window_SkillList_drawSkillCost = Window_SkillList.prototype.drawSkillCost;
Window_SkillList.prototype.drawSkillCost = function(skill, x, y, width) {
	if (this.knsIsSkillToLearn(skill)){
		const old = Window_SkillList.prototype.lineHeight;
		Window_SkillList.prototype.lineHeight = function(){
			return old() >> 1;
		}
		this.contents.fontSize = this.lineHeight() - 2;
		_Window_SkillList_drawSkillCost.apply(this, arguments);
		// draw level
		const levelWidth = 48;
		x += width - levelWidth;
		y += this.lineHeight();
		this.changeTextColor(ColorManager.systemColor());
		this.drawText(TextManager.levelA, x, y, levelWidth);
		const lSkill = KNSMZ_SkillToLearn.getLearnings(this._actor).find(
			function(ln){ return ln && ln.skillId == skill.id; });
		if (lSkill){
			this.changeTextColor(ColorManager.normalColor());
			this.drawText(lSkill.level, x, y, levelWidth, "right");
		}
		Window_SkillList.prototype.lineHeight = old;
		this.resetFontSettings();
	}else{
		_Window_SkillList_drawSkillCost.apply(this, arguments);
	}
};

const _Window_SkillList_drawItemName = Window_SkillList.prototype.drawItemName;
Window_SkillList.prototype.drawItemName = function(item, x, y, width){
	const old = Window_SkillList.prototype.resetTextColor;
	if (this.knsIsSkillToLearn(item)){
		Window_SkillList.prototype.resetTextColor = function(){
			this.changeTextColor(KNSMZ_SkillToLearn.getColor('TextColorLearning'));
			this.changeOutlineColor(ColorManager.outlineColor());
		};
		_Window_SkillList_drawItemName.apply(this, arguments);
	}else{
		_Window_SkillList_drawItemName.apply(this, arguments);
	}
	Window_SkillList.prototype.resetTextColor = old;
};

//========================================================
// alias Window_BattleSkill
//========================================================
Window_BattleSkill.prototype.knsAddSkillToLearn = function(){
	if (KNSMZ_SkillToLearn.displayLearningsInBattle == true){
		Window_SkillList.prototype.knsAddSkillToLearn.call(this);
	}
};
})();